<?php
/**
 * Product tabs function
 *
 * @package xts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

use Elementor\Core\Files\CSS\Post_Preview;
  use Elementor\Group_Control_Image_Size;
  use Elementor\Icons_Manager;
  use Elementor\Plugin;
  use Elementor\Utils;
  use XTS\Elementor\Controls\Autocomplete;
  use XTS\Elementor\Controls\Google_Json;
  use XTS\Elementor\Controls\Buttons;

if ( ! function_exists( 'xts_single_product_tabs_template' ) ) {
	/**
	 * Product tabs template
	 *
	 * @since 1.0.0
	 *
	 * @param array $element_args Associative array of arguments.
	 */
	function xts_single_product_tabs_template( $element_args ) {
		if ( ! xts_is_woocommerce_installed() ) {
			return;
		}

		$default_args = array(
			'disable_additional_info' => 'no',
			'disable_reviews'         => 'no',
			'disable_description'     => 'no',
		);

		$args = wp_parse_args( $element_args, $default_args );

		

		
		global $product;
		$prefix = '_xts_';
		$lesson_id = get_post_meta( get_the_ID(), $prefix . 'select_lesson', true );

		if ( 'yes' === $args['disable_additional_info'] ) {
			add_filter( 'woocommerce_product_tabs', 'xts_single_product_remove_additional_information_tab', 98 );
		}

		if ( 'yes' === $args['disable_reviews'] ) {
			add_filter( 'woocommerce_product_tabs', 'xts_single_product_remove_reviews_tab', 98 );
		}

		if ( 'yes' === $args['disable_description'] ) {
			add_filter( 'woocommerce_product_tabs', 'xts_single_product_remove_description_tab', 98 );
		}

		if ( !empty( $lesson_id )  && is_product()  ) {
			function tab_product_lessons( $tabs ) {
			  // Adds the new tab
		  
				$lesson_tab_text = 'جلسات دوره';
			
				$tabs['lessons_tab'] = array(
				  'title'     => $lesson_tab_text,
				  'priority'  => 21,
				  'callback'  => 'add_product_lesson_content_2'
				);
			  return $tabs;
			}
			add_filter( 'woocommerce_product_tabs', 'tab_product_lessons' );
			}
			
			if ( !empty( $lesson_id )  && is_product()  ) {

			function add_product_lesson_content_2() {
				$prefix = '_xts_';
				$lesson_id = get_post_meta( get_the_ID(), $prefix . 'select_lesson', true );
				$content = Plugin::$instance->frontend->get_builder_content_for_display( $lesson_id );
				
				echo do_shortcode($content);
				
			}
		}
		

		

		wc_get_template( 'single-product/tabs/tabs.php', $args );
	}
}

