<?php
/**
 * Product excerpt function
 *
 * @package iwp
 */

 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'xts_single_product_second_title_template' ) ) {
	/**
	 * Product second title template
	 *
	 * @since 1.0.0
	 *
	 * @param array $element_args Associative array of arguments.
	 */
	function xts_single_product_second_title_template( $element_args ) {

		$default_args = array(
			'tag'                          => 'h4',
		);

		$element_args = wp_parse_args( $element_args, $default_args );

		global $product;
		$second_title = get_post_meta( get_the_ID(), '_xts_single_product_second_title', true );

	
	?>
		<?php if ( !empty($second_title) ) : ?>
			<<?php echo esc_attr( $element_args['tag'] ); ?> class="product_second_title"><?php echo $second_title;?></<?php echo esc_attr( $element_args['tag'] ); ?>>
		<?php endif?>
		
	<?php		
	}


}

