<?php
/**
 * Product excerpt function
 *
 * @package iwp
 */

 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'xts_single_product_sales_template' ) ) {
	/**
	 * Product second title template
	 *
	 * @since 1.0.0
	 *
	 * @param array $element_args Associative array of arguments.
	 */
	function xts_single_product_sales_template( $element_args ) {

		global $product;
		$total_sold = get_post_meta( $product->id, 'total_sales', true );

		$rating = get_post_meta(get_the_ID(), '_wc_average_rating', true);
		$res = $rating / 5 * 100;

	
	?>
<div class="product-grid-details">
        <div class="detail-item sale">
            <span class="count"><?php echo $total_sold; ?></span> 
            <span class="title">
               فروش
            </span>
        </div>
		
        <div class="detail-item rate">
           <span class="count"><?php echo $res; ?><span class="percentage_review">%</span></span>
                <span class="title">رضایت</span>
        </div>
</div>
		
	<?php		
	}


}

