<?php
/**
 * Product excerpt function
 *
 * @package iwp
 */

 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'xts_single_product_learn_template' ) ) {
	/**
	 * Product second title template
	 *
	 * @since 1.0.0
	 *
	 * @param array $element_args Associative array of arguments.
	 */
	function xts_single_product_learn_template( $element_args ) {

		global $product;
		$total_sold = get_post_meta( $product->id, 'total_sales', true );

		$rating = get_post_meta(get_the_ID(), '_wc_average_rating', true);
		$res = $rating / 5 * 100;

	
	?>

<div class="produc-box-tick">
            <div class="product-intro__tick">
						<svg class="svg svg--full"><use xlink:href="#svg_price-ticket">
							<svg id="svg_price-ticket" viewBox="0 0 462 103.7"><g id="Group_5101" transform="translate(-11249.401 1012)"><path class="st0" d="M11709.9-971.2h1.4v-36.9c0-2.2-1.8-4-4-4h-454c-2.2 0-4 1.8-4 4v36.8h1c5.9.2 10.7 5.1 10.7 11s-4.7 10.8-10.7 11h-1v36.9c0 2.2 1.8 4 4 4h454c2.2 0 4-1.8 4-4v-37l-1.1.1h-.4c-6.1 0-11-4.9-11-11 .1-5.9 5.1-10.9 11.1-10.9zm-13 11c0 7 5.6 12.7 12.5 13v34.9c0 1.1-.9 2-2 2h-454c-1.1 0-2-.9-2-2v-34.9c6.5-.7 11.7-6.3 11.6-12.9 0-6.7-5.1-12.3-11.6-12.9v-34.9c0-1.1.9-2 2-2h454c1.1 0 2 .9 2 2v34.8c-6.9.2-12.5 5.9-12.5 12.9z"></path><path class="st0" d="M11479.9-927.7c-.6 0-1-.4-1-1v-9.1c0-.6.4-1 1-1s1 .4 1 1v9.1c0 .6-.4 1-1 1zm0-18.1c-.6 0-1-.4-1-1v-9.1c0-.6.4-1 1-1s1 .4 1 1v9.1c0 .5-.4 1-1 1zm0-18.1c-.6 0-1-.4-1-1v-9.1c0-.6.4-1 1-1s1 .4 1 1v9.1c0 .5-.4 1-1 1zm0-18.2c-.6 0-1-.4-1-1v-9.1c0-.6.4-1 1-1s1 .4 1 1v9.1c0 .6-.4 1-1 1z"></path></g></svg>
						</use></svg>
						<div class="row">
							<div class="col-xs-6">
								<div class="product-intro__tick-count">
									<div class="text"><span><svg class="svg svg--full"><use xlink:href="#svg_basket-tick">
										<svg id="svg_basket-tick" viewBox="0 0 34 43.3"><path class="st0" d="M24 7.3v-.4c0-1.9-.8-3.6-2.1-4.9C20.6.7 18.8 0 17 0c-1.9 0-3.6.7-4.9 2-1.3 1.3-2 3-2.1 4.9v.4H0v30.1c0 1.6.6 3.1 1.8 4.2 1.1 1.1 2.6 1.7 4.2 1.7H28.2c3.3 0 5.9-2.7 5.9-6v-30H24zm-12-.4c0-1.3.5-2.6 1.5-3.5.9-.9 2.1-1.4 3.5-1.4 1.3 0 2.6.5 3.5 1.4 1 .9 1.5 2.2 1.5 3.5v.4H12v-.4zm20 30.4c0 2.2-1.7 4-3.9 4l-.1 1v-1H6c-1.1 0-2.1-.4-2.8-1.1-.8-.8-1.2-1.8-1.2-2.9v-2h30v2zm-30-4v-3h30v3H2zm0-5v-19h8v5c0 .6.4 1 1 1s1-.4 1-1v-5h10v5c0 .6.4 1 1 1s1-.4 1-1v-5h8v19H2z"></path></svg>
									</use></svg>
									</span><var><?php echo $total_sold; ?></var><span>فروش</span>
								</div>
							</div>
						</div>
						<div class="col-xs-6">
							<div class="product-intro__tick-price">
								<div><var><?php echo wp_kses_post( $product->get_price_html() ); ?></var>
								</div>
							</div>
						</div>
					</div>
				</div>

        <div class="product-intro__btns">
					<div class="row">
						<div class="col-xs-12 col-md-6 my-auto">
							<a class="view-lessons button" type="button" rel="noreferrer noopener" href="#"><i class="fal fa-users-class"></i><span>مشاهده جلسات</span></a>
						</div>
						<div class="col-xs-12 col-md-6">
							<?php woocommerce_simple_add_to_cart(); ?>
						</div>
					</div>
		</div>

</div>
		
	<?php		
	}


}

