<?php
/**
 * Product excerpt function
 *
 * @package iwp
 */

use XTS\Framework\Modules;

 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'xts_single_product_course_nav_template' ) ) {
	/**
	 * Product second title template
	 *
	 * @since 1.0.0
	 *
	 * @param array $element_args Associative array of arguments.
	 */
	function xts_single_product_course_nav_template( $element_args ) {

		$default_args = array(

			// Icon.
			'icon_type'                      => 'icon',
			'icon_size'                      => 'm',
			'icon'                           => '',
			'text_icon'                      => '',
			'image'                          => '',
			'image_custom_dimension'         => '',


			'nav_item'                    => '',
			'nav_item_url'                 => '',
			'nav_icon'  => '',

		);

		$element_args = wp_parse_args( $element_args, $default_args );
	
	?>

		<ul class="navbar-nav navbar-nav-right">
            <?php foreach (  $element_args['content_repeater'] as $nav_single ): ?>
				<?php
					$icon_classes        = '';
					$icon_output         = '';
					
					// Icon settings.
					$custom_image_size = isset( $nav_single['image_custom_dimension']['width'] ) && $nav_single['image_custom_dimension']['width'] ? $nav_single['image_custom_dimension'] : array(
						'width'  => 128,
						'height' => 128,
					);
			
					if ( 'image' === $nav_single['icon_type'] && $nav_single['image'] ) {
						$icon_output = xts_get_image_html( $nav_single, 'image' );
			
						if ( xts_is_svg( $nav_single['image']['url'] ) ) {
							$icon_output = '<div class="xts-image-type-svg" style="width:' . esc_attr( $custom_image_size['width'] ) . 'px; height:' . esc_attr( $custom_image_size['height'] ) . 'px;">' . xts_get_svg( '', '', xts_get_image_url( $nav_single['image']['id'], 'image', $nav_single ) ) . '</div>';
						}
					} elseif ( 'text' === $nav_single['icon_type'] ) {
						$icon_output = $nav_single['text_icon'];
					} elseif ( 'icon' === $nav_single['icon_type'] && $nav_single['icon'] ) {
						$icon_output = xts_elementor_get_render_icon( $nav_single['icon'] );
					}

					?>
                <li class="nav-item">
				<div class="nav-icon">
					<?php echo xts_wp_kses_media( $icon_output ); // phpcs:ignore ?>
				</div>
                    <a href="<?php echo $nav_single['nav_item_url']; ?>"><?php echo $nav_single['nav_item']; ?></a>
                </li>	
            <?php endforeach; ?>
			
        </ul>
		
	<?php		
	}


}

