<?php
/**
 * Product add to cart function
 *
 * @package iwp
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'xts_single_product_add_to_cart_template' ) ) {
	/**
	 * Product add to cart template
	 *
	 * @since 1.0.0
	 *
	 * @param array $element_args Associative array of arguments.
	 */
	function xts_single_product_add_to_cart_template( $element_args ) {
		if ( ! xts_is_woocommerce_installed() ) {
			return;
		}

		$default_args = array(
			'stock_status' => 'yes',
			'purchased_lesson_text' => 'yes',
		);

		$element_args = wp_parse_args( $element_args, $default_args ); // phpcs:ignore

		if ( 'yes' !== $element_args['stock_status'] ) {
			add_filter( 'woocommerce_get_stock_html', 'xts_return_empty', 10 );
		}


	if ( 'no' !== $element_args['purchased_lesson_text'] ) {

	global $product;		
    $current_user = wp_get_current_user();
    if (wc_customer_bought_product($current_user->user_email, $current_user->ID, $product->get_id()) ) {
        echo '<div class="single_add_to_cart_button button alt wp-element-button">';
        echo $element_args['purchased_lesson_text_input'];
        echo '</div>';
    } else {
        woocommerce_template_single_add_to_cart();
    }

} else {
	woocommerce_template_single_add_to_cart();
}
		


		if ( 'yes' !== $element_args['stock_status'] ) {
			remove_action( 'woocommerce_get_stock_html', 'xts_return_empty', 10 );
		}
	}
}

