<?php
/**
 * Lesson template function
 *
 * @package iwp
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'xts_lesson_template' ) ) {
	/**
	 * Accordion template
	 *
	 * @param array $element_args Associative array of arguments.
	 *
	 * @since 1.0.0
	 */
	function xts_lesson_template( $element_args ) {
		$default_args = array(
			'image' => '',
			'titlelesson' => '',
			'subtitlelesson' => '',

		);

		$element_args = wp_parse_args( $element_args, $default_args );

		$bought_course = false;
		$current_user = wp_get_current_user();
  
		if( !empty($current_user->user_login) and !empty($current_user->ID) ) {
			if ( wc_customer_bought_product( $current_user->user_login, $current_user->ID, get_the_id() )  ) {
				$bought_course = true;
			}
		}
		global $product;
		$arrow_section = "<i class='fal fa-chevron-down'></i>";

		?>
		<div class="elementory-section">
			<div class="course-section">

  				<div class="course-section-title-elementory <?php if (  'yes' == $element_args['arrowsection'] ) : echo('cursor-pointer'); ?><?php endif; ?>" >
    			<?php echo '<img src="' . $element_args['image']['url'] . '">'; ?>
    			<div class="gheadlinel">
      				<span><?php echo $element_args['titlelesson']; ?></span>
      				<p class="subtitle-lesson"><?php echo $element_args['subtitlelesson']; ?> </p>
    			</div>
    			<?php if (  'yes' == $element_args['arrowsection'] ) : echo($arrow_section); ?><?php endif; ?>
  			</div>

  <div class="panel-group <?php if (  'yes' == $element_args['arrowsection'] ) : echo('deactive'); ?><?php endif; ?>">
  <?php foreach (  $element_args['lessons_list'] as $lesson_single ): ?>
    <div class="course-panel-heading">
      <div class="panel-heading-left">
        <div class="course-lesson-icon">
          <?php echo '<i class="' . $lesson_single['icon'] . '" aria-hidden="true"></i>'; ?>
        </div>

        <div class="title">
          <h4>  <?php echo $lesson_single['subtitlelesson']; ?>
            <?php
            $badge = $lesson_single['label_lesson'];
             if(!empty($badge) ): ?>
              <span class="badge-item <?php echo $lesson_single['label_lesson']; ?>"><?php echo add_class_value_in_any_lang($badge); ?></span>
            <?php endif; ?>
          </h4>
          <p class="subtitle"> <?php echo $lesson_single['subtitlelesson_sub']; ?></p>
        </div>

      </div>

      <div class="panel-heading-right">

        <?php
        $preview_video = $lesson_single['preview_video']['url'];
        if(!empty($preview_video)): ?>
        <a class="video-lesson-preview preview-button" href="<?php echo esc_url( $preview_video ); ?>"><i class="fa fa-play-circle"></i><?php esc_html_e( 'پیشنمایش', 'studiare' ); ?></a>
        <a class="video-lesson-preview preview-button for-mobile" href="<?php echo esc_url( $preview_video ); ?>"><i class="fa fa-play-circle"></i></a>
        <?php endif; ?>




        <?php
              $download_lesson = $lesson_single['download_lesson']['url'];
              $download_lesson = apply_filters('wcpl_download_lesson', $download_lesson);
                if(!empty($download_lesson)):
        ?>
  			<?php if($bought_course): ?>
          <a class="download-button" href="<?php echo esc_url( $download_lesson ); ?>"><i class="fa fa-download"></i></a>
  			<?php elseif ($lesson_single["private_lesson"] !== "yes") : ?>
          <a class="download-button" href="<?php echo esc_url( $download_lesson ); ?>"><i class="fa fa-download"></i></a>
        <?php elseif ($lesson_single["private_lesson"] !== "no") : ?>
  				<div class="download-button gray"><i class="fa fa-download"></i></div>
  			<?php endif; ?>
  			<?php endif; ?>







        <?php if( $lesson_single["private_lesson"] !== "no" ): ?>
              <div class="private-lesson">

			  <?php if($bought_course): ?>
				<?php echo '<i class="fa fa-unlock green-lock"></i>'; ?>
				<?php  else : ?>
					<?php echo '<i class="fa fa-lock"></i>'; ?>
			  <?php endif; ?>


        <span>
		<?php if($bought_course): ?>
          <?php esc_html_e('در دسترس', 'studiare'); ?>
           <?php else : ?>
            <?php  esc_html_e('خصوصی', 'studiare'); ?>
		  <?php endif; ?>
        </span>

		</div>
        <?php endif; ?>

      </div>

  </div>

  <div class="panel-content">
    <div class="panel-content-inner">

      <?php
      if( $lesson_single["private_lesson"] !== "no" ) {
      if($bought_course) {
       echo $lesson_single['lesson_content'];
     } else {
       esc_html_e( 'این درس خصوصی می باشد. برای دسترسی به تمام دروس لازم است دروه را خریداری نمایید.', 'studiare' );
     }
   } elseif ( $lesson_single["private_lesson"] !== "yes" ) {
       echo $lesson_single['lesson_content'];
   }
       ?>

    </div>
  </div>



<?php endforeach; ?>
</div>
</div>
</div>
		
		<?php
	}
}
