<?php
/**
 * Template used to display post content on single pages.
 *
 * @package xts
 */


 $prefix = '_xts_';
$download_box_content = get_post_meta(get_the_ID(), $prefix . 'download_box_text', true);
$download_box_password = get_post_meta(get_the_ID(), $prefix . 'download_box_password', true);

 $link_title_1 = get_post_meta(get_the_ID(), $prefix . 'download_box_title_1', true);
 $link_title_2 = get_post_meta(get_the_ID(), $prefix . 'download_box_title_2', true);
 $link_title_3 = get_post_meta(get_the_ID(), $prefix . 'download_box_title_3', true);
 $link_title_4 = get_post_meta(get_the_ID(), $prefix . 'download_box_title_4', true);
 $link_title_5 = get_post_meta(get_the_ID(), $prefix . 'download_box_title_5', true);

 $link_url_1 = get_post_meta(get_the_ID(), $prefix . 'download_box_url_1', true);
 $link_url_2 = get_post_meta(get_the_ID(), $prefix . 'download_box_url_2', true);
 $link_url_3 = get_post_meta(get_the_ID(), $prefix . 'download_box_url_3', true);
 $link_url_4 = get_post_meta(get_the_ID(), $prefix . 'download_box_url_4', true);
 $link_url_5 = get_post_meta(get_the_ID(), $prefix . 'download_box_url_5', true);


 $report_form = xts_get_opt('blog_single_download_box_form_report');
 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( xts_get_single_post_classes() ); ?>>
	<?php if ( xts_get_opt( 'blog_single_content_boxed' ) ) : ?>
		<div class="xts-single-post-boxed">
	<?php endif; ?>

	<?php if ( ! xts_get_opt( 'page_title_show_current_post_title' ) ) : ?>
		<h1 class="xts-single-post-title xts-entities-title">
			<?php the_title(); ?>
		</h1>
	<?php endif; ?>

	<div class="xts-single-post-header">
		<div class="xts-post-meta">
			<?php xts_meta_post_author(); ?>
			<?php xts_meta_post_date(); ?>
		</div>

		<?php xts_meta_post_categories(); ?>
	</div>

	<?php if ( xts_get_opt( 'blog_single_content_boxed' ) ) : ?>
		</div>
	<?php endif; ?>

	<?php if ( xts_has_post_thumbnail( get_the_ID(), true ) ) : ?>
		<div class="xts-single-post-thumb">
			<?php xts_single_post_thumbnail(); ?>
		</div>
	<?php endif; ?>

	<?php if ( xts_get_opt( 'blog_single_content_boxed' ) ) : ?>
		<div class="xts-single-post-boxed">
	<?php endif; ?>

	<div class="xts-single-post-content">
		<?php the_content(); ?>
		<?php wp_link_pages(); ?>
	</div>


	

	<?php if ( !empty($download_box_content) ) : ?>
		<div class="post-inner-download-box">

			<?php if ( !empty($download_box_content) ) : ?>
				<div class="help_download">
					<?php echo ($download_box_content); ?>
				</div>
			<?php endif; ?>

			<div class="box_download">

  			<span><i class="fa fa-folder-open-o"></i> دانلود فایل ها </span>
				<div class="box_content">
				<?php if ( !empty($link_title_1) ) : ?>
  <a href="<?php echo ($link_url_1); ?>"><i class="far fa-download"></i><?php echo ($link_title_1); ?></a>
<?php endif; ?>

<?php if ( !empty($link_title_2) ) : ?>
  <a href="<?php echo ($link_url_2); ?>"><i class="far fa-download"></i><?php echo ($link_title_2); ?></a>
<?php endif; ?>

<?php if ( !empty($link_title_3) ) : ?>
  <a href="<?php echo ($link_url_3); ?>"><i class="far fa-download"></i><?php echo ($link_title_3); ?></a>
<?php endif; ?>

<?php if ( !empty($link_title_4) ) : ?>
  <a href="<?php echo ($link_url_4); ?>"><i class="far fa-download"></i><?php echo ($link_title_4); ?></a>
<?php endif; ?>

<?php if ( !empty($link_title_5) ) : ?>
  <a href="<?php echo ($link_url_5); ?>"><i class="far fa-download"></i><?php echo ($link_title_5); ?></a>
<?php endif; ?>
				</div>
			</div>

			<p class="button_download">
  				<span class="password" id="password" data-toggle="tooltip" data-placement="top" title="" data-original-title="جهت کپی پسورد کلیک کنید">پسورد فایل : <span id="password_copy"><?php echo ($download_box_password); ?></span></span>
  				<a class="link-not" type="button" data-toggle="collapse" data-target="#report" aria-expanded="false" aria-controls="report">گزارش خرابی لینک</a>
  			</p>

			<div class="collapse">
    		<div class="well">
				<?php echo do_shortcode ($report_form); ?>
				</div>
			</div>

		</div>
	<?php endif; ?>



	<?php if ( get_the_tag_list() || xts_get_opt( 'blog_single_share_buttons' ) ) : ?>
		<footer class="xts-single-post-footer">
			<?php if ( get_the_tag_list() ) : ?>
				<div class="xts-tags-list">
					<?php the_tags( '', ' ' ); ?>
				</div>
			<?php endif; ?>

			<?php if ( xts_get_opt( 'blog_single_share_buttons' ) ) : ?>
				<?php xts_social_buttons_template( xts_get_default_value( 'single_post_social_buttons_args' ) ); ?>
			<?php endif; ?>
		</footer>
	<?php endif; ?>

	<?php if ( get_the_author_meta( 'description' ) && xts_get_opt( 'blog_single_author_bio' ) ) : ?>
		<?php xts_author_bio(); ?>
	<?php endif; ?>

	<?php if ( xts_get_opt( 'blog_single_navigation' ) ) : ?>
		<?php xts_get_template_part( 'templates/single-posts-navigation' ); ?>
	<?php endif; ?>

	<?php if ( xts_get_opt( 'blog_single_content_boxed' ) ) : ?>
		</div>
	<?php endif; ?>

</article>

<?php if ( xts_get_opt( 'blog_single_content_boxed' ) ) : ?>
	<div class="xts-single-post-boxed">
<?php endif; ?>

<?php if ( xts_get_opt( 'blog_single_related_posts' ) ) : ?>
	<?php xts_get_related_posts( $post ); ?>
<?php endif; ?>

<?php if ( comments_open() || get_comments_number() ) : ?>
	<?php comments_template(); ?>
<?php endif; ?>

<?php if ( xts_get_opt( 'blog_single_content_boxed' ) ) : ?>
	</div>
<?php endif; ?>
