<?php
/**
 * Excerpt map
 *
 * @package iwp
 */

namespace XTS\Elementor\Single_Product_Builder;

use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Plugin;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
/**
 * Elementor widget that inserts an embeddable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Course_nav extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'xts_single_product_course_nav';
	}

	/**
	 * Get widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'ناوبری سایدبار دوره', 'meta-theme' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'xf-el-image-or-svg';
	}

	/**
	 * Get widget categories.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'xts-learn-elements' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
        
        /**
		 * Infobox settings
		 */
		$this->start_controls_section(
			'infoboxes_content',
			[
				'label' => esc_html__( 'ناوبری سایدبار دوره', 'meta-theme' ),
			]
		);

		$repeater = new Repeater();

		$repeater->start_controls_tabs( 'infobox_tabs' );

		$repeater->start_controls_tab(
			'link_tab',
			[
				'label' => esc_html__( 'هدف منو', 'meta-theme' ),
			]
		);

		xts_get_nav_url_map( $repeater );

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'icon_tab',
			[
				'label' => esc_html__( 'Icon', 'meta-theme' ),
			]
		);

		xts_get_infobox_content_icon_map( $repeater );

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'text_tab',
			[
				'label' => esc_html__( 'عنوان منو', 'meta-theme' ),
			]
		);

		xts_get_nav_item_title_map( $repeater );

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		/**
		 * Repeater settings
		 */
		$this->add_control(
			'content_repeater',
			[
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ nav_item }}}',
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'icon'        => [
							'value'   => 'fas fa-store',
							'library' => 'fa-solid',
						],
						'nav_item'       => 'توضیحات',
					],
					[
						'icon'        => [
							'value'   => 'fas fa-user',
							'library' => 'fa-solid',
						],
						'nav_item'       => 'سوالات متدوال',
					],
					[
						'icon'        => [
							'value'   => 'fas fa-shield-alt',
							'library' => 'fa-solid',
						],
						'nav_item'       => 'اساتید دوره',
					],
					[
						'icon'        => [
							'value'   => 'fas fa-sync-alt',
							'library' => 'fa-solid',
						],
						'nav_item'       => 'نظرات کاربران',

					],
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		global $post;

		if ( ! is_singular( 'product' ) ) {
			$post = xts_get_preview_product(); // phpcs:ignore
			setup_postdata( $post );
		}

		xts_single_product_course_nav_template( $this->get_settings_for_display() );

		if ( ! is_singular( 'product' ) ) {
			wp_reset_postdata();
		}
	}
}

Plugin::instance()->widgets_manager->register( new Course_nav() );
