<?php
/**
 * Add_To_Cart map
 *
 * @package iwp
 */

namespace XTS\Elementor\Single_Product_Builder;

use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Elementor widget that inserts an embeddable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Add_To_Cart extends Widget_Base {
	/**
	 * Get widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'xts_single_product_add_to_cart';
	}

	/**
	 * Get widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Add to cart', 'meta-theme' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'xf-woo-el-add-to-cart';
	}

	/**
	 * Get widget categories.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'xts-product-elements' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		/**
		 * Style tab
		 */

		/**
		 * General settings
		 */
		$this->start_controls_section(
			'general_style_section',
			[
				'label' => esc_html__( 'General', 'meta-theme' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_align',
			[
				'label'        => esc_html__( 'Text alignment', 'meta-theme' ),
				'type'         => 'xts_buttons',
				'options'      => [
					'left'   => [
						'title' => esc_html__( 'Left', 'meta-theme' ),
						'image' => XTS_ASSETS_IMAGES_URL . '/elementor/align/left.svg',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'meta-theme' ),
						'image' => XTS_ASSETS_IMAGES_URL . '/elementor/align/center.svg',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'meta-theme' ),
						'image' => XTS_ASSETS_IMAGES_URL . '/elementor/align/right.svg',
					],
				],
				'prefix_class' => 'xts-textalign-',
				'render_type'  => 'template',
				'default'      => 'right',
			]
		);

		$this->add_control(
			'label_position',
			[
				'label'        => esc_html__( 'Swatches label position', 'meta-theme' ),
				'type'         => Controls_Manager::SELECT,
				'options'      => [
					'without' => esc_html__( 'Without', 'meta-theme' ),
					'left'    => esc_html__( 'Left', 'meta-theme' ),
					'top'     => esc_html__( 'Top', 'meta-theme' ),
				],
				'prefix_class' => 'xts-label-position-',
				'render_type'  => 'template',
				'default'      => 'right',
			]
		);

		$this->add_control(
			'stock_status',
			[
				'label'        => esc_html__( 'Stock status', 'meta-theme' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => esc_html__( 'Yes', 'meta-theme' ),
				'label_off'    => esc_html__( 'No', 'meta-theme' ),
				'return_value' => 'yes',
			]
		);

		$this->add_control(
			'purchased_lesson_text',
			[
				'label'        => esc_html__( 'لیبل خریدار محصول هستید؟', 'meta-theme' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				  'default' => 'no',
				  'options' => [
					 'yes' => __( 'بله', 'meta-theme' ),
					 'no' => __( 'خیر', 'meta-theme' ),
				  ],
			]
		);

		$this->add_control(
			'purchased_lesson_text_input',
			[
				'label'        => esc_html__( 'متن دلخواه لیبل', 'meta-theme' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				  'default' => 'شما خریدار محصول هستید',
				  'condition' => [
					'purchased_lesson_text' => [ 'yes' ],
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Main price settings
		 */
		$this->start_controls_section(
			'main_price_style_section',
			[
				'label' => esc_html__( 'Main price (variable product)', 'meta-theme' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'main_price_custom_typography',
				'label'    => esc_html__( 'Custom typography', 'meta-theme' ),
				'selector' => '{{WRAPPER}} .price, {{WRAPPER}} span.amount, {{WRAPPER}} del',
			]
		);

		$this->add_control(
			'main_price_custom_color',
			[
				'label'     => esc_html__( 'Custom color', 'meta-theme' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price, {{WRAPPER}} span.amount, {{WRAPPER}} del' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Old price settings
		 */
		$this->start_controls_section(
			'sale_price_style_section',
			[
				'label' => esc_html__( 'Old price (variable product)', 'meta-theme' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'sale_price_custom_typography',
				'label'    => esc_html__( 'Custom typography', 'meta-theme' ),
				'selector' => '{{WRAPPER}} .price del, {{WRAPPER}} del span.amount',
			]
		);

		$this->add_control(
			'sale_price_custom_color',
			[
				'label'     => esc_html__( 'Custom color', 'meta-theme' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price del, {{WRAPPER}} del span.amount' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Suffix settings
		 */
		$this->start_controls_section(
			'tax_text_style_section',
			[
				'label' => esc_html__( 'Suffix (variable product)', 'meta-theme' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'tax_text_custom_typography',
				'label'    => esc_html__( 'Custom typography', 'meta-theme' ),
				'selector' => '{{WRAPPER}} .woocommerce-price-suffix',
			]
		);

		$this->add_control(
			'tax_text_custom_color',
			[
				'label'     => esc_html__( 'Custom color', 'meta-theme' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-price-suffix' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		global $post;

		if ( ! is_singular( 'product' ) ) {
			$post = xts_get_preview_product(); // phpcs:ignore
			setup_postdata( $post );
		}

		xts_single_product_add_to_cart_template( $this->get_settings_for_display() );

		if ( ! is_singular( 'product' ) ) {
			wp_reset_postdata();
		}
	}
}

Plugin::instance()->widgets_manager->register( new Add_To_Cart() );
