<?php
/**
 * Accordion map
 *
 * @package xts
 */

namespace XTS\Elementor;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Elementor widget that inserts an embeddable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Leason extends Widget_Base {
	/**
	 * Get widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'xts_leason';
	}

	/**
	 * Get widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'عنصر ارائه دروس', 'meta-theme' );
	}

	/**
	 * Get widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'xf-el-accordion';
	}

	/**
	 * Get widget categories.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'xts-elements' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		/**
		 * Content tab
		 */

		 $this->start_controls_section(
			'lesson_section',
			[
			   'label' => esc_html__( 'تنظیمات فصل', 'studiare-core' ),
			   'type' => Controls_Manager::SECTION,
			]
		 );
	
		   $this->add_control(
			  'image',
			  [
				 'label' => __( 'آیکون فصل(اختیاری)', 'studiare-core' ),
				 'type' => \Elementor\Controls_Manager::MEDIA,
				 'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				 ],
			  ]
		   );
	
		   $this->add_control(
			  'titlelesson',
			  [
				 'label' => __( 'عنوان فصل دوره', 'studiare-core' ),
				 'type' => \Elementor\Controls_Manager::TEXT,
	
			  ]
		   );
	
		   $this->add_control(
			  'subtitlelesson',
			  [
				 'label' => __( 'زیرنویس عنوان فصل دوره', 'studiare-core' ),
				 'type' => \Elementor\Controls_Manager::TEXTAREA,
	
			  ]
		   );
	
	
		   $this->add_control(
			  'arrowsection',
			  [
				 'label' => __( 'قابلیت باز و بسته شدن؟', 'studiare-core' ),
				 'type' => \Elementor\Controls_Manager::SWITCHER,
				 'label_on' => esc_html_x("بله", 'pelleh'),
						 'label_off' => esc_html_x("خیر", 'pelleh'),
				 'default' => 'yes'
	
			  ]
		   );
	
	
		 $this->end_controls_section();
	
		  $this->start_controls_section(
			 'lessons_section',
			 [
				'label' => esc_html__( 'درس ها', 'studiare-core' ),
				'type' => Controls_Manager::SECTION,
			 ]
		  );
	
		  $repeater = new \Elementor\Repeater();
	
	
	
			$repeater->add_control(
			   'private_lesson',
			   [
				  'label' => __( 'دوره خصوصی است؟', 'studiare-core' ),
				  'type' => \Elementor\Controls_Manager::SELECT,
				  'default' => 'no',
				  'options' => [
					 'yes' => __( 'بله', 'studiare-core' ),
					 'no' => __( 'خیر', 'studiare-core' ),
				  ],
			   ]
			);
	
	
			$repeater->add_control(
			   'subtitlelesson',
			   [
				  'label' => __( 'عنوان درس', 'studiare-core' ),
				  'type' => \Elementor\Controls_Manager::TEXT,
	
			   ]
			);
	
			$repeater->add_control(
			   'subtitlelesson_sub',
			   [
				  'label' => __( 'زیرنویس عنوان', 'learn-soogh' ),
				  'type' => \Elementor\Controls_Manager::TEXT,
	
			   ]
			);
	
		  $repeater->add_control(
			 'icon',
			 [
				'label' => __( 'آیکون درس', 'studiare-core' ),
				'type' => \Elementor\Controls_Manager::ICON,
	
			 ]
		  );
	
		  $repeater->add_control(
			 'label_lesson',
			 [
				'label' => __( 'لیبل درس', 'studiare-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => [
				   'free' => __( 'رایگان', 'studiare-core' ),
				   'video' => __( 'ویدئو', 'studiare-core' ),
				   'exam' => __( 'آزمون', 'studiare-core' ),
				   'quiz' => __( 'کوئیز', 'studiare-core' ),
				   'lecture' => __( 'مقاله', 'studiare-core' ),
				   'practice' => __( 'تمرین', 'studiare-core' ),
				   'attachments' => __( 'فایل ضمیمه', 'studiare-core' ),
				   'sound' => __( 'صوت', 'studiare-core' ),
				],
			 ]
		  );
	
	
		  $repeater->add_control(
			 'preview_video',
			 [
				'label' => __( 'پیشنمایش ویدئویی', 'studiare-core' ),
				'type' => \Elementor\Controls_Manager::URL
			 ]
		  );
	
		  $repeater->add_control(
			 'download_lesson',
			 [
				'label' => __( 'لینک فایل خصوصی درس', 'studiare-core' ),
				'type' => \Elementor\Controls_Manager::URL
			 ]
		  );
	
		  $repeater->add_control(
			 'lesson_content',
			 [
				'label' => __( 'محتوای دوره', 'studiare-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG
			 ]
		  );
	
	
		  $this->add_control(
			 'lessons_list',
			 [
				'label' => __( 'لیست دروس', 'studiare-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{subtitlelesson}}}',
	
			 ]
		  );
	
		  $this->end_controls_section();



		  /**
		 * Style tab
		 */

		/**
		 * General settings
		 */
		$this->start_controls_section(
			'general_style_section',
			[
				'label' => esc_html__( 'عمومی', 'meta-theme' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'lesson_color',
			[
				'label'     => esc_html__( 'رنگ اصلی درس', 'meta-theme' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementory-section .course-section .panel-group .course-panel-heading.active .panel-heading-left .course-lesson-icon i,{{WRAPPER}} .elementory-section .course-section .panel-group .course-panel-heading:hover .panel-heading-left .course-lesson-icon i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'preview_color',
			[
				'label'     => esc_html__( 'رنگ دکمه پیشنمایش ویدئویی دروس', 'meta-theme' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementory-section .course-section .panel-group .course-panel-heading .preview-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'download_color',
			[
				'label'     => esc_html__( 'رنگ دکمه دانلود دروس', 'meta-theme' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .panel-group .course-panel-heading .download-button' => 'background-color: {{VALUE}};',
				],
			]
		);



		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		xts_lesson_template( $this->get_settings_for_display() );
	}
}

Plugin::instance()->widgets_manager->register( new Leason() );
