<?php
/**
 * Default header builder settings
 *
 * @package iwp
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$header_settings = array(
	'overlap'          => array(
		'id'          => 'overlap',
		'title'       => 'همپوشانی',
		'type'        => 'switcher',
		'tab'         => 'عمومی',
		'value'       => false,
		'description' => 'سربرگ را بر روی محتوا پوشش بده.',
	),

	'boxed'            => array(
		'id'          => 'boxed',
		'title'       => 'جعبه ای',
		'type'        => 'switcher',
		'tab'         => 'عمومی',
		'value'       => false,
		'description' => 'سربرگ به جای حالت تمام عرض، جعبه ای خواهد شد.',
		'requires'    => array(
			'overlap' => array(
				'comparison' => 'equal',
				'value'      => true,
			),
		),
	),

	'background_hover' => array(
		'id'          => 'background_hover',
		'title'       => esc_html__( 'پس زمینه در حالت هاور', 'meta-theme' ),
		'description' => esc_html__( 'Overlap header with transparent background will have a white background on mouse over.', 'meta-theme' ),
		'type'        => 'switcher',
		'tab'         => 'عمومی',
		'value'       => false,
		'requires'    => array(
			'overlap' => array(
				'comparison' => 'equal',
				'value'      => true,
			),
		),
	),

	'full_width'       => array(
		'id'          => 'full_width',
		'title'       => 'محتوای کشیده',
		'description' => esc_html__( 'Make the header content wider then your website container.', 'meta-theme' ),
		'type'        => 'switcher',
		'tab'         => 'عمومی',
		'value'       => false,
	),

	'sticky_effect'    => array(
		'id'          => 'sticky_effect',
		'title'       => 'افکت چسبان',
		'type'        => 'selector',
		'tab'         => 'سربرگ چسبان',
		'value'       => 'stick',
		'options'     => array(
			'stick' => array(
				'value' => 'stick',
				'label' => 'چسبان هنگام اسکرول',
			),
			'slide' => array(
				'value' => 'slide',
				'label' => 'اسلاید بعد از اسکرول به پایین.',
			),
		),
		'description' => 'شما می توانید بین دو افکت چسبان انتخاب کنید.',
	),

	'sticky_clone'     => array(
		'id'          => 'sticky_clone',
		'title'       => 'کپی کردن سربرگ چسبان',
		'type'        => 'switcher',
		'tab'         => 'سربرگ چسبان',
		'value'       => false,
		'requires'    => array(
			'sticky_effect' => array(
				'comparison' => 'equal',
				'value'      => 'slide',
			),
		),
		'description' => 'سربرگ چسبان به صورت خودکار عناصر سربرگ مانند لوگو، سبد خرید ، مقایسه و علاقه مندی و ... را در یک خط نمایش خواهد داد.',
	),

	'sticky_height'    => array(
		'id'          => 'sticky_height',
		'title'       => 'ارتفاع سربرگ چسبان',
		'type'        => 'slider',
		'tab'         => 'سربرگ چسبان',
		'from'        => 0,
		'to'          => 200,
		'value'       => 50,
		'units'       => 'px',
		'description' => 'Determine header height for sticky header value in pixels.',
		'requires'    => array(
			'sticky_clone'  => array(
				'comparison' => 'equal',
				'value'      => true,
			),
			'sticky_effect' => array(
				'comparison' => 'equal',
				'value'      => 'slide',
			),
		),
	),

	'sticky_shadow'    => array(
		'id'          => 'sticky_shadow',
		'title'       => 'سایه سربرگ چسبان',
		'type'        => 'switcher',
		'tab'         => 'سربرگ چسبان',
		'value'       => true,
		'description' => 'یک سایه به سربرگ هنگامی که چسبان شد اضافه کن.',
	),

	'hide_on_scroll'   => array(
		'id'          => 'hide_on_scroll',
		'title'       => esc_html__( 'مخفی کردن در هنگام اسکرول به پایین', 'meta-theme' ),
		'description' => esc_html__( 'مخفی کردن سربرگ چسبان در هنگام اسکرول صفحه به سمت پایین و نمایش آن در هنگام اسکرول به بالا', 'meta-theme' ),
		'type'        => 'switcher',
		'tab'         => 'سربرگ چسبان',
		'value'       => false,
	),
);

return apply_filters( 'xts_default_header_settings', $header_settings );
